#! /bin/bash

# called by dracut
check() {
    require_binaries integritysetup dmsetup awk blkid || return 1

    [[ $hostonly ]] && {
        local DEVICES DEV
        DEVICES=$(dmsetup ls --target integrity | awk '{print $1}')

        while read -r DEV; do
            dinfo "check device $DEV"
            return 0;
        done <<< "$DEVICES"
    }
    dwarn "no integrity targets"
    return 255
}

# called by dracut
depends() {
    echo rootfs-block dm
    return 0
}

cmdline() {
    [[ $hostonly ]] && {
        local DEVICES DEV PART_UUID ALGORITHM
        DEVICES=$(dmsetup ls --target integrity | awk '{print $1}')
        
        while read -r DEV; do
            PART_UUID=$(blkid -o value -s PARTUUID $( integritysetup status "$DEV" | grep device | awk '{print $2}' ))
            ALGORITHM=$(dmsetup table "$DEV" | cut -d ' ' -f 9- | awk '{for(i=1;i<=NF;++i) { split($(i),t,":");if (t[1] == "internal_hash") { print t[2] } }}') 
            printf " %s" "rd.dmintegrity=$PART_UUID,$DEV,$ALGORITHM"
        done <<< "$DEVICES"
    }
}

# called by dracut
installkernel() {
    instmods dm-integrity
}

# called by dracut
install() {
    if [[ $hostonly_cmdline == "yes" ]]; then
        local _integrityconf
        _integrityconf=$(cmdline)
        [[ $_integrityconf ]] && printf "%s\n" "$_integrityconf" >> "${initdir}/etc/cmdline.d/90dm-integrity.conf"
    fi

    inst_multiple integritysetup integritysetup_udev
    inst_hook cmdline 30 "$moddir/parse-dm-integrity.sh"
    inst_rules "$moddir/69-dm-integrity.rules"
}
